/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.activate;

import com.ibm.hwmca.base.activate.ActivateErrorIDs;
import com.ibm.hwmca.base.activate.ActivationTaskletData;
import com.ibm.hwmca.base.activate.ActivationTaskletTargetData;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.ActionDescriptor;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.UserTaskManager;

public class ConfirmActivateBean
extends PanelBean {
    private static final String TRACE_MASKT = "XACTCABT";
    private static final String TRACE_MASKF = "XACTCABF";
    private static final String TRACE_MASKD = "XACTCABD";
    private static final String REQUEST_EVENT = "event";
    private ItemDescriptor[] m_idActivateObjTable;
    private ColumnDescriptor[] m_cdActivateObjTableStructure;
    private int[] m_iActivateObjTableSelection;
    private ActionDescriptor[] m_adContextMenu;
    private static final int NUMBER_OF_COLUMNS = 3;
    private boolean _highlight = false;
    private ActivationTaskletData atd;

    public ConfirmActivateBean() {
        Trace.trace(TRACE_MASKD, "<> ConfirmActivateBean() constructor");
        this.setBeanName("ConfirmActivateBean");
    }

    public ConfirmActivateBean(ActivationTaskletData atd) {
        Trace.trace(TRACE_MASKD, "<> ConfirmActivateBean(ActivationTaskletData) constructor");
        Trace.trace(TRACE_MASKD, "  ActivationTaskletData = " + atd);
        this.atd = atd;
    }

    public int getActivateObjTableRowStatus() {
        return 3;
    }

    public int getActivateObjTableRowCount() {
        return this.m_idActivateObjTable.length / 3;
    }

    public ItemDescriptor[] getActivateObjTableRowAt(int index) {
        ItemDescriptor[] rowAt = new ItemDescriptor[3];
        for (int i = 0; i < 3; ++i) {
            rowAt[i] = this.m_idActivateObjTable[index * 3 + i];
        }
        Trace.trace(TRACE_MASKD, "<> getActivateObjTableRowAt(" + index + ")");
        return rowAt;
    }

    public void setActivateObjTableRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
        for (int i = 0; i < items.length; ++i) {
            Trace.trace(TRACE_MASKD, " item is " + items[i]);
            Trace.trace(TRACE_MASKD, " item.title is " + items[i].getTitle());
            Trace.trace(TRACE_MASKD, " item.name is " + items[i].getName());
            if (items[i].getUserObject() != null) {
                Trace.trace(TRACE_MASKD, " item.contents is " + (String)items[i].getUserObject());
            }
            this.m_idActivateObjTable[index * 3 + i] = items[i];
        }
        Trace.trace(TRACE_MASKD, "<> setActivateObjTableRowAt(" + index + ", " + items.length + " column's data)");
    }

    public int[] getActivateObjTableSelection() {
        Trace.trace(TRACE_MASKD, "<> getActivateObjTableSelection()");
        return this.m_iActivateObjTableSelection;
    }

    public void setActivateObjTableSelection(int[] selected) throws IllegalUserDataException {
        if (selected != null) {
            Trace.trace(TRACE_MASKD, "<> setActivateObjTableSelection(" + selected.length + " selections)");
        } else {
            Trace.trace(TRACE_MASKD, "<> setActivateObjTableSelection(null)");
        }
        this.m_iActivateObjTableSelection = selected;
    }

    public ActionDescriptor[] getContextMenuList() {
        return this.m_adContextMenu;
    }

    public ActivationTaskletData getActivationTaskletData() {
        return this.atd;
    }

    public void setActivationTaskletData(ActivationTaskletData atd) {
        this.atd = atd;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void save() {
    }

    public void load() {
        ActivationTaskletTargetData[] attd = this.atd.getActivationTaskletTargetData();
        Trace.trace(TRACE_MASKD, "Number of lines is " + attd.length);
        int numlines = attd.length;
        this.m_idActivateObjTable = new ItemDescriptor[numlines * 3];
        ItemDescriptor[] newRow = new ItemDescriptor[3];
        this._highlight = false;
        for (int i = 0; i < numlines; ++i) {
            newRow[0] = new ItemDescriptor("NAME" + i, attd[i].getName().trim());
            newRow[1] = new ItemDescriptor("NEXT" + i, attd[i].getNextProfileName().trim());
            String name = attd[i].getLastUsedProfileName().trim();
            if (name.length() == 0) {
                LocalizableText ltName = new LocalizableText("com/ibm/hwmca/base/res/text", "activate.nolastprof.text");
                name = ltName.toString();
            }
            newRow[2] = new ItemDescriptor("LAST" + i, name);
            if (attd[i].getHighlightConfirmation()) {
                this._highlight = true;
            }
            this.setActivateObjTableRowAt(i, newRow);
        }
        if (this._highlight) {
            Trace.trace(TRACE_MASKD, "Highlight flag = TRUE");
        } else {
            Trace.trace(TRACE_MASKD, "Highlight flag = FALSE");
        }
        this.m_cdActivateObjTableStructure = new ColumnDescriptor[0];
        this.m_iActivateObjTableSelection = new int[0];
        this.m_adContextMenu = new ActionDescriptor[0];
    }

    public void panelAction(TaskActionEvent tae) {
        Trace.trace(TRACE_MASKF, " -> panelAction()");
        try {
            String command = tae.getActionCommand();
            Trace.trace(TRACE_MASKF, "panel action = " + command);
            Trace.trace(TRACE_MASKF, "THIS = " + this);
            if (this.userTaskManager == null) {
                this.userTaskManager = (UserTaskManager)tae.getSource();
                Trace.trace(TRACE_MASKF, "userTaskManager = " + this.userTaskManager);
            }
            ConfirmActivateBean bean = (ConfirmActivateBean)this.userTaskManager.getDataObjects()[0];
            this.userTaskManager.storeAllElements();
            if (command.equals("CANCEL")) {
                Trace.trace(TRACE_MASKF, "Cancel");
                PanelTaskletRequest request = new PanelTaskletRequest();
                request.setData(REQUEST_EVENT, tae);
                this.postTaskletRequest(request);
            } else if (command.endsWith("YesButton")) {
                Trace.trace(TRACE_MASKF, "YES - do the activation");
                PanelTaskletRequest request = new PanelTaskletRequest();
                this.atd.setCommand(1);
                request.setData("Key A", this.atd);
                bean.postTaskletRequest(request);
            } else if (command.endsWith("NoButton")) {
                Trace.trace(TRACE_MASKF, "NO - do NOT do the activation");
                PanelTaskletRequest request = new PanelTaskletRequest();
                this.atd.setCommand(2);
                request.setData("Key A", this.atd);
                this.postTaskletRequest(request);
            } else if (command.endsWith("DetailsItem")) {
                Trace.trace(TRACE_MASKF, "SHOW DETAILS - the user double-clicked");
                int[] selection = bean.getActivateObjTableSelection();
                Trace.trace(TRACE_MASKF, "selection = " + selection);
                Trace.trace(TRACE_MASKF, "Number of selections = " + selection.length);
                if (selection.length == 0) {
                    Trace.trace(TRACE_MASKF, "Default selection to first item");
                    selection = new int[]{0};
                }
                ActivationTaskletData atdSelected = bean.getActivationTaskletData();
                Trace.trace(TRACE_MASKF, "atdSelected = " + atdSelected);
                ActivationTaskletTargetData[] attd = atdSelected.getActivationTaskletTargetData();
                Trace.trace(TRACE_MASKF, "attd = " + attd);
                Trace.trace(TRACE_MASKF, "Targets to look thru = " + attd.length);
                atdSelected.setShowDetailsFor(attd[selection[0]]);
                PanelTaskletRequest request = new PanelTaskletRequest();
                atdSelected.setCommand(3);
                request.setData("Key A", atdSelected);
                bean.postTaskletRequest(request);
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "exception is " + e);
            new FrameworkLog(ActivateErrorIDs.LOGINFO, 18176, e).log();
        }
        Trace.trace(TRACE_MASKF, " <- panelAction()");
    }
}

